$(function(){
	
	//attach event to the forgot password checkbox
	$('#admin_forgot').on('change', function() {
		if($(this).prop("checked") == true){
			//show reset password form
			$("#li_password,#li_remember_me").slideUp("slow",function(){
				$("#submit_button").html('<span class="icon-key"></span> Reset My Password');
			});
			
		}else{
			//show login form
			$("#li_password,#li_remember_me").slideDown("slow",function(){
				$("#submit_button").html('<span class="icon-keyhole"></span> Sign In');
			});
		}
		
	});

	//override the form submit event
	$("#form_login").on("submit",function(){
		if($("#admin_forgot").prop("checked") == true){
			//if forgot password submitted
			if($("#admin_username").val().trim() == ""){
				alert('Please enter your email address!');
			}else{
				var admin_email_address = $("#admin_username").val().trim();
				$("#submit_button").after("<div class='forgot_password_loader'><img src='images/loader_small_grey.gif' /></div>");
				$("#submit_button").html('<span class="icon-key"></span> Sending...');
				$("#submit_button").prop("disabled",true);
				$("#admin_forgot").prop("disabled",true);

				//do the ajax call to reset the password
				axios.post('reset_password.php', {
					target_email: admin_email_address
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						Swal.fire({
							icon: 'success',
							title: 'Reset Password Link Sent',
							html: 'A reset password link has been generated and sent to your email. Please check your email and follow the instruction.',
							width: '30%',
							customClass: {
								title: 'swal2-title-success',
								htmlContainer: 'swal2-html-container-bold'
							},
							showConfirmButton: true,
							allowOutsideClick: false
						}).then((result) => {
							if(result.isConfirmed) {
								$(".forgot_password_loader").remove();
								$("#submit_button").html('<span class="icon-key"></span> Reset My Password');
								$("#submit_button").prop("disabled",false);
								$("#admin_forgot").prop("disabled",false);
							}
						});
					}else{
						//display error dialog
						Swal.fire({
							toast: true,
							html: `Error: ${response.data.message}`,
							icon: 'error',
							width: '30%',
						});

						//restore the buttons on the dialog
						$(".forgot_password_loader").remove();
						$("#submit_button").html('<span class="icon-key"></span> Reset My Password');
						$("#submit_button").prop("disabled",false);
						$("#admin_forgot").prop("disabled",false);
					}
				})
				.catch(function (error) {
					Swal.fire({
						toast: true,
						text: `Error: ${error}`,
						icon: 'error'
					});

					//restore the buttons on the dialog
					$(".forgot_password_loader").remove();
					$("#submit_button").html('<span class="icon-key"></span> Reset My Password');
					$("#submit_button").prop("disabled",false);
					$("#admin_forgot").prop("disabled",false);
				});
			}
			 
			return false;
		}else{
			return true;
		}
	});

});